/*
 * Decompiled with CFR 0.152.
 */
package amidas.proxy.konos.core;

import amidas.proxy.core.KonosPushClient;
import amidas.proxy.konos.adapters.response.FederationInfoResponseAdapter;
import amidas.proxy.konos.adapters.response.UserInfoResponseAdapter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import cotton.restful.RestfulClient;
import cotton.restful.core.exceptions.RestfulFailure;
import cotton.restful.setups.java.RestfulClient;
import io.intino.konos.server.activity.services.AuthService;
import io.intino.konos.server.activity.services.auth.FederationInfo;
import io.intino.konos.server.activity.services.auth.Space;
import io.intino.konos.server.activity.services.auth.UserInfo;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotLogout;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.konos.server.activity.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.konos.server.activity.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Token;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class AmidasKonosAccessor
implements AuthService {
    private final Space space;
    private final URL amidasUrl;
    private Map<URL, KonosPushClient> pushClientMap = new HashMap<URL, KonosPushClient>();
    private cotton.restful.RestfulClient client;

    public AmidasKonosAccessor(Space space, URL amidasUrl) {
        this.space = space;
        this.amidasUrl = amidasUrl;
        this.client = new RestfulClient();
    }

    @Override
    public URL url() {
        return this.amidasUrl;
    }

    @Override
    public Space space() {
        return this.space;
    }

    @Override
    public AuthService.Authentication authenticate() throws SpaceAuthCallbackUrlIsNull {
        return new AuthService.Authentication(){
            private OAuthService authService;
            private io.intino.konos.server.activity.services.auth.Token requestToken;
            private io.intino.konos.server.activity.services.auth.Token accessToken;
            {
                this.authService = AmidasKonosAccessor.this.serviceOf(AmidasKonosAccessor.this.amidasUrl, AmidasKonosAccessor.this.space);
            }

            @Override
            public io.intino.konos.server.activity.services.auth.Token requestToken() throws CouldNotObtainRequestToken {
                try {
                    this.requestToken = AmidasKonosAccessor.this.tokenFrom(Optional.of(this.authService.getRequestToken()));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainRequestToken();
                }
                this.accessToken = null;
                return this.requestToken;
            }

            @Override
            public URL authenticationUrl(io.intino.konos.server.activity.services.auth.Token requestToken) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != requestToken) {
                    return null;
                }
                try {
                    return new URL(this.authService.getAuthorizationUrl(AmidasKonosAccessor.this.token(Optional.of(requestToken))));
                }
                catch (Exception e) {
                    throw new CouldNotObtainAuthorizationUrl();
                }
            }

            @Override
            public io.intino.konos.server.activity.services.auth.Token accessToken() {
                return this.accessToken;
            }

            @Override
            public io.intino.konos.server.activity.services.auth.Token accessToken(io.intino.konos.server.activity.services.auth.Verifier verifier) throws CouldNotObtainAccessToken {
                if (this.requestToken == null) {
                    return null;
                }
                try {
                    Token accessToken = this.authService.getAccessToken(AmidasKonosAccessor.this.token(Optional.of(this.requestToken)), AmidasKonosAccessor.this.verifier(verifier));
                    this.accessToken = AmidasKonosAccessor.this.tokenFrom(Optional.of(accessToken));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAccessToken();
                }
                return this.accessToken;
            }

            @Override
            public void invalidate() throws CouldNotInvalidateAccessToken {
                try {
                    AmidasKonosAccessor.this.client.post(AmidasKonosAccessor.this.amidasUrl, String.format("/api/invalidate/%s", this.accessToken.id()));
                }
                catch (Exception e) {
                    throw new CouldNotInvalidateAccessToken();
                }
            }
        };
    }

    @Override
    public boolean valid(io.intino.konos.server.activity.services.auth.Token accessToken) {
        try {
            return this.getAndCheck(this.amidasUrl, String.format("/api/valid/%s", accessToken.id()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public FederationInfo info(io.intino.konos.server.activity.services.auth.Token accessToken) throws CouldNotObtainInfo {
        try {
            RestfulClient.Response response = this.client.get(this.amidasUrl, String.format("/api/info/%s", accessToken.id()));
            return (FederationInfo)new FederationInfoResponseAdapter().adapt(response.content());
        }
        catch (Exception exception) {
            throw new CouldNotObtainInfo();
        }
    }

    @Override
    public UserInfo me(io.intino.konos.server.activity.services.auth.Token accessToken) throws CouldNotObtainInfo {
        try {
            RestfulClient.Response response = this.client.get(this.amidasUrl, String.format("/api/me/%s", accessToken.id()));
            return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
        }
        catch (RestfulFailure failure) {
            throw new CouldNotObtainInfo();
        }
    }

    @Override
    public void logout(io.intino.konos.server.activity.services.auth.Token accessToken) throws CouldNotLogout {
        try {
            this.client.post(this.amidasUrl, String.format("/api/logout/%s", accessToken.id()));
        }
        catch (Exception e) {
            throw new CouldNotLogout();
        }
    }

    @Override
    public void addPushListener(io.intino.konos.server.activity.services.auth.Token accessToken, AuthService.FederationNotificationListener listener) throws CouldNotObtainInfo {
        if (!this.pushClientMap.containsKey(this.amidasUrl)) {
            FederationInfo info = this.info(accessToken);
            this.pushClientMap.put(this.amidasUrl, this.createNotificationClient(info));
        }
        KonosPushClient pushClient = this.pushClientMap.get(this.amidasUrl);
        pushClient.addListener(listener);
    }

    private KonosPushClient createNotificationClient(FederationInfo info) {
        return new AmidasPushClient(info);
    }

    private io.intino.konos.server.activity.services.auth.Token tokenFrom(Optional<Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return () -> ((Token)token.get()).getToken();
    }

    private Token token(Optional<io.intino.konos.server.activity.services.auth.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new Token(token.get().id(), "");
    }

    private Verifier verifier(io.intino.konos.server.activity.services.auth.Verifier verifier) {
        return new Verifier(verifier.value());
    }

    private OAuthService serviceOf(URL federation, Space space) throws SpaceAuthCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf(federation)).apiKey(space.name()).apiSecret(space.secret());
        URL callbackUrl = space.authCallbackUrl();
        if (callbackUrl == null) {
            throw new SpaceAuthCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf(URL federation) {
        String AuthenticationPath = "/authentication/%s";
        String RequestTokenPath = "/authentication/token/request";
        String AccessTokenPath = "/authentication/token/access";
        final String url = federation.toString();
        return new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return url + "/authentication/token/request";
            }

            public String getAccessTokenEndpoint() {
                return url + "/authentication/token/access";
            }

            public String getAuthorizationUrl(Token token) {
                return url + String.format("/authentication/%s", token.getToken());
            }
        };
    }

    private boolean getAndCheck(URL url, String resource) throws RestfulFailure {
        return Boolean.valueOf(this.client.get(url, resource).content());
    }

    private static class AmidasPushClient
    implements KonosPushClient {
        private final FederationInfo info;
        private WebSocketClient client;
        private List<AuthService.FederationNotificationListener> listenerList;

        public AmidasPushClient(FederationInfo info) {
            this.info = info;
            this.listenerList = new ArrayList<AuthService.FederationNotificationListener>();
            this.createClient();
        }

        private void createClient() {
            this.client = new WebSocketClient(this.info.pushServerUri()){

                public void onOpen(ServerHandshake serverHandshake) {
                }

                public void onMessage(String message) {
                    this.notify(message);
                }

                public void onClose(int i, String s, boolean b) {
                }

                public void onError(Exception e) {
                }
            };
            this.client.connect();
        }

        @Override
        public void notify(String rawMessage) {
            Message message = this.messageOf(rawMessage);
            if (!rawMessage.contains("userLoggedOut") && !rawMessage.contains("userAdded")) {
                return;
            }
            for (AuthService.FederationNotificationListener listener : this.listenerList) {
                if (message.name.equals("userLoggedOut")) {
                    listener.userLoggedOut((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
                }
                if (!message.name.equals("userAdded")) continue;
                listener.userAdded((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
            }
        }

        private Message messageOf(String rawMessage) {
            return Message.build(rawMessage);
        }

        @Override
        public void addListener(AuthService.FederationNotificationListener listener) {
            this.listenerList.add(listener);
        }

        private static class Message {
            private String name;
            private JsonObject rawParameters;

            public Message(String name) {
                this.name = name;
            }

            public String name() {
                return this.name;
            }

            public JsonElement param(String name) {
                if (this.rawParameters == null) {
                    return null;
                }
                return this.rawParameters.get(name);
            }

            public static Message build(String rawData) {
                JsonElement raw = new JsonParser().parse(rawData);
                if (raw instanceof JsonPrimitive) {
                    return new Message(raw.getAsString());
                }
                JsonObject rawMessage = (JsonObject)raw;
                Message message = new Message(rawMessage.get("name").getAsString());
                message.rawParameters = rawMessage.get("parameters").getAsJsonObject();
                return message;
            }
        }
    }
}

