/*
 * Decompiled with CFR 0.152.
 */
package amidas.proxy.konos.core;

import amidas.proxy.core.KonosPushClient;
import amidas.proxy.konos.adapters.response.FederationInfoResponseAdapter;
import amidas.proxy.konos.adapters.response.UserInfoResponseAdapter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.intino.konos.alexandria.ui.services.AuthService;
import io.intino.konos.alexandria.ui.services.auth.FederationInfo;
import io.intino.konos.alexandria.ui.services.auth.Space;
import io.intino.konos.alexandria.ui.services.auth.Token;
import io.intino.konos.alexandria.ui.services.auth.UserInfo;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotInvalidateAccessToken;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotLogout;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;
import io.intino.konos.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.konos.alexandria.ui.services.auth.exceptions.SpaceAuthCallbackUrlIsNull;
import io.intino.konos.restful.RestfulApi;
import io.intino.konos.restful.core.RestfulAccessor;
import io.intino.konos.restful.exceptions.RestfulFailure;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class AmidasKonosAccessor
implements AuthService {
    private final Space space;
    private final URL amidasUrl;
    private Map<URL, KonosPushClient> pushClientMap = new HashMap<URL, KonosPushClient>();
    private RestfulApi api;

    public AmidasKonosAccessor(Space space, URL amidasUrl) {
        this.space = space;
        this.amidasUrl = amidasUrl;
        this.api = new RestfulAccessor();
    }

    @Override
    public URL url() {
        return this.amidasUrl;
    }

    @Override
    public Space space() {
        return this.space;
    }

    @Override
    public AuthService.Authentication authenticate() throws SpaceAuthCallbackUrlIsNull {
        return new AuthService.Authentication(){
            private OAuthService authService;
            private Token requestToken;
            private Token accessToken;
            {
                this.authService = AmidasKonosAccessor.this.serviceOf(AmidasKonosAccessor.this.amidasUrl, AmidasKonosAccessor.this.space);
            }

            @Override
            public Token requestToken() throws CouldNotObtainRequestToken {
                try {
                    this.requestToken = AmidasKonosAccessor.this.tokenFrom(Optional.of(this.authService.getRequestToken()));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainRequestToken(exception);
                }
                this.accessToken = null;
                return this.requestToken;
            }

            @Override
            public URL authenticationUrl(Token requestToken) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != requestToken) {
                    return null;
                }
                try {
                    return new URL(this.authService.getAuthorizationUrl(AmidasKonosAccessor.this.token(Optional.of(requestToken))));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAuthorizationUrl(exception);
                }
            }

            @Override
            public Token accessToken() {
                return this.accessToken;
            }

            @Override
            public Token accessToken(io.intino.konos.alexandria.ui.services.auth.Verifier verifier) throws CouldNotObtainAccessToken {
                if (this.requestToken == null) {
                    return null;
                }
                try {
                    org.scribe.model.Token accessToken = this.authService.getAccessToken(AmidasKonosAccessor.this.token(Optional.of(this.requestToken)), AmidasKonosAccessor.this.verifier(verifier));
                    this.accessToken = AmidasKonosAccessor.this.tokenFrom(Optional.of(accessToken));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAccessToken(exception);
                }
                return this.accessToken;
            }

            @Override
            public void invalidate() throws CouldNotInvalidateAccessToken {
                try {
                    AmidasKonosAccessor.this.api.post(AmidasKonosAccessor.this.amidasUrl, String.format("/api/invalidate/%s", this.accessToken.id()));
                }
                catch (Exception exception) {
                    throw new CouldNotInvalidateAccessToken(exception);
                }
            }
        };
    }

    @Override
    public boolean valid(Token accessToken) {
        try {
            return this.getAndCheck(this.amidasUrl, String.format("/api/valid/%s", accessToken.id()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public FederationInfo info(Token accessToken) throws CouldNotObtainInfo {
        try {
            RestfulApi.Response response = this.api.get(this.amidasUrl, String.format("/api/info/%s", accessToken.id()));
            return (FederationInfo)new FederationInfoResponseAdapter().adapt(response.content());
        }
        catch (Exception exception) {
            throw new CouldNotObtainInfo(exception);
        }
    }

    @Override
    public UserInfo me(Token accessToken) throws CouldNotObtainInfo {
        try {
            RestfulApi.Response response = this.api.get(this.amidasUrl, String.format("/api/me/%s", accessToken.id()));
            return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
        }
        catch (RestfulFailure exception) {
            throw new CouldNotObtainInfo((Exception)((Object)exception));
        }
    }

    @Override
    public void logout(Token accessToken) throws CouldNotLogout {
        try {
            this.api.post(this.amidasUrl, String.format("/api/logout/%s", accessToken.id()));
        }
        catch (Exception exception) {
            throw new CouldNotLogout(exception);
        }
    }

    @Override
    public void addPushListener(Token accessToken, AuthService.FederationNotificationListener listener) throws CouldNotObtainInfo {
        if (!this.pushClientMap.containsKey(this.amidasUrl)) {
            FederationInfo info = this.info(accessToken);
            this.pushClientMap.put(this.amidasUrl, this.createNotificationClient(info));
        }
        KonosPushClient pushClient = this.pushClientMap.get(this.amidasUrl);
        pushClient.addListener(listener);
    }

    private KonosPushClient createNotificationClient(FederationInfo info) {
        return new AmidasPushClient(info);
    }

    private Token tokenFrom(Optional<org.scribe.model.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return () -> ((org.scribe.model.Token)token.get()).getToken();
    }

    private org.scribe.model.Token token(Optional<Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new org.scribe.model.Token(token.get().id(), "");
    }

    private Verifier verifier(io.intino.konos.alexandria.ui.services.auth.Verifier verifier) {
        return new Verifier(verifier.value());
    }

    private OAuthService serviceOf(URL federation, Space space) throws SpaceAuthCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf(federation)).apiKey(space.name()).apiSecret(space.secret());
        URL callbackUrl = space.authCallbackUrl();
        if (callbackUrl == null) {
            throw new SpaceAuthCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf(URL federation) {
        String AuthenticationPath = "/authentication/%s";
        String RequestTokenPath = "/authentication/token/request";
        String AccessTokenPath = "/authentication/token/access";
        final String url = federation.toString();
        return new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return url + "/authentication/token/request";
            }

            public String getAccessTokenEndpoint() {
                return url + "/authentication/token/access";
            }

            public String getAuthorizationUrl(org.scribe.model.Token token) {
                return url + String.format("/authentication/%s", token.getToken());
            }
        };
    }

    private boolean getAndCheck(URL url, String resource) throws RestfulFailure {
        return Boolean.valueOf(this.api.get(url, resource).content());
    }

    private static class AmidasPushClient
    implements KonosPushClient {
        private final FederationInfo info;
        private WebSocketClient client;
        private List<AuthService.FederationNotificationListener> listenerList;

        public AmidasPushClient(FederationInfo info) {
            this.info = info;
            this.listenerList = new ArrayList<AuthService.FederationNotificationListener>();
            this.createClient();
        }

        private void createClient() {
            this.client = new WebSocketClient(this.info.pushServerUri()){

                public void onOpen(ServerHandshake serverHandshake) {
                }

                public void onMessage(String message) {
                    this.notify(message);
                }

                public void onClose(int i, String s, boolean b) {
                }

                public void onError(Exception e) {
                }
            };
            this.client.connect();
        }

        @Override
        public void notify(String rawMessage) {
            Message message = this.messageOf(rawMessage);
            if (!rawMessage.contains("userLoggedOut") && !rawMessage.contains("userAdded")) {
                return;
            }
            for (AuthService.FederationNotificationListener listener : this.listenerList) {
                if (message.name.equals("userLoggedOut")) {
                    listener.userLoggedOut((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
                }
                if (!message.name.equals("userAdded")) continue;
                listener.userAdded((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
            }
        }

        private Message messageOf(String rawMessage) {
            return Message.build(rawMessage);
        }

        @Override
        public void addListener(AuthService.FederationNotificationListener listener) {
            this.listenerList.add(listener);
        }

        private static class Message {
            private String name;
            private JsonObject rawParameters;

            public Message(String name) {
                this.name = name;
            }

            public String name() {
                return this.name;
            }

            public JsonElement param(String name) {
                if (this.rawParameters == null) {
                    return null;
                }
                return this.rawParameters.get(name);
            }

            public static Message build(String rawData) {
                JsonElement raw = new JsonParser().parse(rawData);
                if (raw instanceof JsonPrimitive) {
                    return new Message(raw.getAsString());
                }
                JsonObject rawMessage = (JsonObject)raw;
                Message message = new Message(rawMessage.get("name").getAsString());
                message.rawParameters = rawMessage.get("parameters").getAsJsonObject();
                return message;
            }
        }
    }
}

