package io.intino.amidas.box;

import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.net.URL;
import java.lang.reflect.Type;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonDeserializer;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.restaccessor.RequestBuilder;
import io.intino.alexandria.restaccessor.core.RestAccessorNotifier;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;

import io.intino.amidas.box.schemas.*;

public class InfoAccessor {
	private final URL url;
	private final RestAccessorNotifier notifier = new RestAccessorNotifier();
	private int timeoutMillis = 120 * 1_000;
	private io.intino.alexandria.restaccessor.OutBox outBox = null;
	private Map<String, String> additionalHeaders = new HashMap<>();



	public InfoAccessor(URL url) {
		this.url = url;

	}

	public InfoAccessor(URL url, int timeoutMillis) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;

	}

	public InfoAccessor(URL url, int timeoutMillis, java.io.File outBoxDirectory, int intervalRetrySeconds) {
		this.url = url;
		this.timeoutMillis = timeoutMillis;
		this.outBox = new io.intino.alexandria.restaccessor.OutBox(outBoxDirectory, intervalRetrySeconds);

	}

	public void addCommonHeader(String name, String value) {
		additionalHeaders.put(name, value);
	}

	public void addRequestSerializer(Type type, JsonSerializer<?> adapter) {
		io.intino.alexandria.restaccessor.adapters.RequestAdapter.addCustomAdapter(type, adapter);
	}

	public void addResponseDeserializer(Type type, JsonDeserializer<?> adapter) {
		io.intino.alexandria.restaccessor.adapters.ResponseAdapter.addCustomAdapter(type, adapter);
	}

	public String getValidToken(String token) throws InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.build(RequestBuilder.Method.GET, "/api" + "/valid" + "/" + token);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), String.class);
		} catch (AlexandriaException e) {

			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public AmidasInfo getInfo(String token) throws Unauthorized, Conflict, InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.build(RequestBuilder.Method.GET, "/api" + "/info" + "/" + token);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), AmidasInfo.class);
		} catch (AlexandriaException e) {
			if (e instanceof Unauthorized) throw ((Unauthorized) e);
			else if (e instanceof Conflict) throw ((Conflict) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public UserInfo getMe(String token) throws Unauthorized, InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.build(RequestBuilder.Method.GET, "/api" + "/me" + "/" + token);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), UserInfo.class);
		} catch (AlexandriaException e) {
			if (e instanceof Unauthorized) throw ((Unauthorized) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public String postInvalidate(String token) throws Unauthorized, InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.build(RequestBuilder.Method.POST, "/api" + "/invalidate" + "/" + token);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), String.class);
		} catch (AlexandriaException e) {
			if (e instanceof Unauthorized) throw ((Unauthorized) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}

	public String postLogout(String token) throws Unauthorized, InternalServerError {
		RequestBuilder builder = new RequestBuilder(this.url).timeOut(this.timeoutMillis);
		additionalHeaders.forEach((k,v) -> builder.headerParameter(k,v));
		RequestBuilder.Request request = builder
			.build(RequestBuilder.Method.POST, "/api" + "/logout" + "/" + token);
		try {
			io.intino.alexandria.restaccessor.Response response = request.execute();
			return io.intino.alexandria.restaccessor.adapters.ResponseAdapter.adapt(response.content(), String.class);
		} catch (AlexandriaException e) {
			if (e instanceof Unauthorized) throw ((Unauthorized) e);
			if (outBox != null) outBox.push(request);
			throw new InternalServerError(e.message());
		}
	}


}