import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractOpenLoginDialog from "../../../gen/displays/components/AbstractOpenLoginDialog";
import OpenLoginDialogNotifier from "../../../gen/displays/notifiers/OpenLoginDialogNotifier";
import OpenLoginDialogRequester from "../../../gen/displays/requesters/OpenLoginDialogRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OpenLoginDialog extends AbstractOpenLoginDialog {

	constructor(props) {
		super(props);
		this.notifier = new OpenLoginDialogNotifier(this);
		this.requester = new OpenLoginDialogRequester(this);
	};

    render() {
        return (<div>Hola mundo!</div>);
    }

}

export default withStyles(styles, { withTheme: true })(withSnackbar(OpenLoginDialog));
DisplayFactory.register("OpenLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(OpenLoginDialog)));