import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractFacebookLoginDialog from "../../gen/displays/AbstractFacebookLoginDialog";
import FacebookLoginDialogNotifier from "../../gen/displays/notifiers/FacebookLoginDialogNotifier";
import FacebookLoginDialogRequester from "../../gen/displays/requesters/FacebookLoginDialogRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class FacebookLoginDialog extends AbstractFacebookLoginDialog {

	constructor(props) {
		super(props);
		this.notifier = new FacebookLoginDialogNotifier(this);
		this.requester = new FacebookLoginDialogRequester(this);
	};

    render() {
        return (<div>Facebook</div>);
    }

    includeFacebookSDK = () => {
        (function(d, s, id){
            var js, fjs = d.getElementsByTagName(s)[0];
            if (d.getElementById(id)) {return;}
            js = d.createElement(s); js.id = id;
            js.src = "//connect.facebook.net/en_US/sdk.js";
            fjs.parentNode.insertBefore(js, fjs);
        }(document, 'script', 'facebook-jssdk'));
    };

}

export default withStyles(styles, { withTheme: true })(withSnackbar(FacebookLoginDialog));
DisplayFactory.register("FacebookLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(FacebookLoginDialog)));