import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysOpenProfileDialog from "platform-elements/gen/displays/templates/OpenProfileDialog";
import DisplaysPasswordProfileDialog from "platform-elements/gen/displays/templates/PasswordProfileDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileDialogListNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ProfileDialogListRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileDialogList extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileDialogListNotifier(this);
		this.requester = new ProfileDialogListRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<DisplaysOpenProfileDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_706026729">
				</DisplaysOpenProfileDialog>
				<DisplaysPasswordProfileDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1072237474">
				</DisplaysPasswordProfileDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileDialogList));
DisplayFactory.register("ProfileDialogList", withStyles(styles, { withTheme: true })(withSnackbar(ProfileDialogList)));