import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysOpenProfileDialog from "platform-elements/gen/displays/templates/OpenProfileDialog";
import DisplaysPasswordProfileDialog from "platform-elements/gen/displays/templates/PasswordProfileDialog";
import DisplaysCertificateProfileDialog from "platform-elements/gen/displays/templates/CertificateProfileDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ProfileRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Profile extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileNotifier(this);
		this.requester = new ProfileRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367" format="block" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233" layout="vertical" width="80.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a_507265729" format="h4" mode="normal" translate={true} value="Personal information">
						</UiText>
						<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a1334226940" label="Photo" format="doubleAirTop" width="200px" height="200px">
						</UiImageEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a6907696" label="User name" format="doubleAirTop" mode="normal" placeholder="" readonly={true}>
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a_434524980" label="Full name" format="doubleAirTop" mode="normal" placeholder="">
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a_1134463790" label="Email address" format="doubleAirTop" mode="normal" placeholder="">
						</UiTextEditable>
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_452091233.a_1599300114" label="Language" format="doubleAirTop" multipleSelection={false} placeholder="Select language" maxMenuHeight={300}>
						</UiSelectorComboBox>
					</UiBlock>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a267212713" layout="vertical">
						<DisplaysOpenProfileDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a267212713.a1849158417">
						</DisplaysOpenProfileDialog>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a330993976" layout="vertical">
						<DisplaysPasswordProfileDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a330993976.a_994168401">
						</DisplaysPasswordProfileDialog>
					</UiBlockConditional>
					<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_619806424" layout="vertical">
						<DisplaysCertificateProfileDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a922752367.a_619806424.a702118705">
						</DisplaysCertificateProfileDialog>
					</UiBlockConditional>
				</UiBlock>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(Profile));
DisplayFactory.register("Profile", withStyles(styles, { withTheme: true })(withSnackbar(Profile)));