import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PasswordLoginDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import PasswordLoginDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PasswordLoginDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PasswordLoginDialogNotifier(this);
		this.requester = new PasswordLoginDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1161922978" label="Username" mode="normal" placeholder="Fill username" focused={true}>
				</UiTextEditable>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a320776227" label="Password" format="doubleAirTop" mode="normal" placeholder="Fill password" type="password">
				</UiTextEditable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(PasswordLoginDialog));
DisplayFactory.register("PasswordLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(PasswordLoginDialog)));