import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysOpenLoginDialog from "platform-elements/gen/displays/templates/OpenLoginDialog";
import DisplaysPasswordLoginDialog from "platform-elements/gen/displays/templates/PasswordLoginDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LoginDialogsNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LoginDialogsRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginDialogs extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LoginDialogsNotifier(this);
		this.requester = new LoginDialogsRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<DisplaysOpenLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a549786112">
				</DisplaysOpenLoginDialog>
				<DisplaysPasswordLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a296345011">
				</DisplaysPasswordLoginDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginDialogs));
DisplayFactory.register("LoginDialogs", withStyles(styles, { withTheme: true })(withSnackbar(LoginDialogs)));