import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysOpenLoginDialog from "platform-elements/gen/displays/templates/OpenLoginDialog";
import DisplaysPasswordLoginDialog from "platform-elements/gen/displays/templates/PasswordLoginDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LoginDialogListNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LoginDialogListRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginDialogList extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LoginDialogListNotifier(this);
		this.requester = new LoginDialogListRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<DisplaysOpenLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_358095954">
				</DisplaysOpenLoginDialog>
				<DisplaysPasswordLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a544153157">
				</DisplaysPasswordLoginDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginDialogList));
DisplayFactory.register("LoginDialogList", withStyles(styles, { withTheme: true })(withSnackbar(LoginDialogList)));