import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiSignText from "alexandria-ui-elements/src/displays/components/SignText";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CertificateProfileDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CertificateProfileDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CertificateProfileDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CertificateProfileDialogNotifier(this);
		this.requester = new CertificateProfileDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a795327986" format="h4" mode="normal">
				</UiText>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1188659029" format="airTop" visible={false} layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1188659029.a_515157813" format="airBottom" mode="normal" translate={true} value="Link with certificate by using @firma">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1188659029.a1343405812" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1188659029.a1343405812.a1281640304" title="Link" target="self" mode="Button" size="Small" highlighted="Outline">
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_231345429" format="airTop" visible={false} layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_231345429.a_47800345" format="airBottom" mode="normal" translate={true} value="Linking with @firma... follow steps in @firma app">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413002226" format="airTop" visible={false} layout="vertical">
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413002226.a1971637053" format="airBottom" mode="normal" translate={true} value="Linked with %s">
					</UiText>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413002226.a178790747" layout="horizontal">
						<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_413002226.a178790747.a_1944470675" title="Unlink" target="self" mode="Button" size="Small" highlighted="Outline">
						</UiAction>
					</UiBlock>
				</UiBlock>
				<UiSignText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1476777810" title="Sign" target="self" mode="Button" size="Medium" visible={false} signFormat="XAdES">
				</UiSignText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CertificateProfileDialog));
DisplayFactory.register("CertificateProfileDialog", withStyles(styles, { withTheme: true })(withSnackbar(CertificateProfileDialog)));