import React from "react";
import { withStyles } from '@material-ui/core/styles';
import DisplaysOutUsernameItem from "app-elements/gen/displays/items/OutUsernameItem";
import DisplaysOutFullNameItem from "app-elements/gen/displays/items/OutFullNameItem";
import DisplaysOutEmailItem from "app-elements/gen/displays/items/OutEmailItem";
import DisplaysOutSpaceItem from "app-elements/gen/displays/items/OutSpaceItem";
import DisplaysOutLoggedInDateItem from "app-elements/gen/displays/items/OutLoggedInDateItem";
import UiRow from "alexandria-ui-elements/src/displays/components/Row";
import OnlineUsersTableRowNotifier from "alexandria-ui-elements/gen/displays/notifiers/RowNotifier";
import OnlineUsersTableRowRequester from "alexandria-ui-elements/gen/displays/requesters/RowRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OnlineUsersTableRow extends UiRow {

	constructor(props) {
		super(props);
		this.notifier = new OnlineUsersTableRowNotifier(this);
		this.requester = new OnlineUsersTableRowRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return this.renderRow(
			<React.Fragment>
				<DisplaysOutUsernameItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_445113605" style={{width:"25%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never"></DisplaysOutUsernameItem>
				<DisplaysOutFullNameItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1025103650" style={{width:"25%",paddingRight:"10px"}} hidden="Never"></DisplaysOutFullNameItem>
				<DisplaysOutEmailItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1678734686" style={{width:"15%",paddingRight:"10px"}} hidden="Never"></DisplaysOutEmailItem>
				<DisplaysOutSpaceItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1989671767" style={{width:"15%",paddingRight:"10px"}} hidden="Never"></DisplaysOutSpaceItem>
				<DisplaysOutLoggedInDateItem context={this._context.bind(this)} owner={this._owner.bind(this)} id="a518955419" style={{width:"15%",paddingRight:"10px"}} hidden="Never"></DisplaysOutLoggedInDateItem>
			</React.Fragment>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OnlineUsersTableRow));
DisplayFactory.register("OnlineUsersTableRow", withStyles(styles, { withTheme: true })(withSnackbar(OnlineUsersTableRow)));