import { createTheme } from '@material-ui/core/styles';

const Theme = (function () {
	var theme = null;
	var provider = {
		create: () => {
			theme = createTheme({
				palette : {
					primary : { main: "#005b9f" },
					secondary : { main: "#ff9100" },
					error : { main: "#f44336" },
					contrastThreshold : "3",
					tonalOffset : "0.2",
					grey : {
						primary: "#888",
						secondary: '#ddd'
					}
				},
				typography : {
					fontFamily : '"-apple-system","BlinkMacSystemFont","Segoe UI","Roboto","Helvetica Neue","Arial","sans-serif","Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol"',
					fontSize : 11,
					useNextVariants: true
				},
				formats: {
					h1: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'25pt' },
					h2: { color:'#05673c',textShadow:'2px 2px 2px #fff',fontSize:'20pt' },
					h3: { fontSize:'15pt' },
					h4: { fontSize:'14pt',fontWeight:'400' },
					h5: { fontSize:'12pt' },
					h6: { lineHeight:'17pt',fontSize:'12pt' },
					body1: {  },
					body2: {  },
					subtitle1: {  },
					subtitle2: {  },
					relative: { position:'relative' },
					grey: { background:'#efefef' },
					greyColor: { color:'#777' },
					onTop: { zIndex:'1' },
					secondary: {  },
					footerFormat: { background:'#efefef',padding:'1px 7px',borderTop:'1px solid #aaa' },
					doubleAirTop: { marginTop:'20px' },
					airTop: { marginTop:'10px' },
					middleAirTop: { marginTop:'5px' },
					doubleAirBottom: { marginBottom:'20px' },
					airBottom: { marginBottom:'10px' },
					middleAirBottom: { marginBottom:'5px' },
					airLeft: { marginLeft:'10px' },
					smallAirLeft: { marginLeft:'4px' },
					airRight: { marginRight:'10px' },
					middleAirRight: { marginRight:'5px' },
					air: { padding:'10px' },
					block: { position:'relative',marginTop:'20px' },
					autoOverflow: { overflow:'auto' },
					appTitleStyle: { marginTop:'14px',color:'#888' },
					airMenuRight: { marginRight:'4px' },
					minWidth: { minWidth:'400px' },
					whiteBackground: { background:'white',borderRadius:'3px',height:'100%',border:'1px solid #efefef' },
					description: { fontSize:'10pt',color:'grey' },
					propertyValue: { wordBreak:'break-all' },
					autoWidth: { width:'auto' },
					backgroundLogin: { position:'absolute',bottom:'0',top:'0',width:'100%',height:'100%',zIndex:'0',objectFit:'none' },
					backgroundDarkMode: { backgroundColor:'black' },
					loginError: { textAlign:'center',width:'100%',color:'red' },
					airHeader: { padding:'4px 20px' },
					separator: { borderBottom:'1px solid #ddd',width:'100%' }
				}
			});
			return theme;
		},
		get: () => {
			return theme;
		},
	};
	return provider;
})();

export default Theme;