import AlexandriaUiI18n from "alexandria-ui-elements/gen/I18n";

const I18n = (function () {
    var cache = {};

	var translators = {
		"pt" : {
			"Affirm" : "Confirmar",
			"Sign" : "Firmar",
			"Cancel" : "Cancelar",
			"OK" : "Aceitar",
			"Back" : "Anterior",
			"Logout" : "Cerrar sessão",
			"Federation" : "Federação",
			"Next" : "Siguiente",
			"Value is out of range" : "Valor não permitido",
			"Search..." : "Buscar...",
			"no results" : "sem elementos de feno",
			"one result" : "un resultado",
			"results" : "resultados",
			"User not granted to execute operation" : "Permissão negada. Não pode executar a operação",
			"Value is out of range" : "Valor não permitido",
			"User unknown" : "Usuario desconocido",
			"Loading application..." : "Cargando aplicativo...",
			"Starting application..." : "Iniciando aplicação...",
			"Fill username" : "Insira seu nome de usuário",
			"Username" : "nome de usuário",
			"Fill password" : "Insira sua senha",
			"Change password" : "Mudar senha",
			"Password" : "Senha",
			"Type password" : "Digite a senha",
			"Retype password" : "Digite novamente a senha",
			"Log in" : "Iniciar sessão",
			"Fill valid username" : "Preencha um nome de usuário válido",
			"Wrong password" : "Senha incorreta",
			"User unknown" : "Usuário não encontrado",
			"Under construction" : "Em construção",
			"Type password to save changes" : "Digite a senha para salvar as alterações",
			"Typed password doesn't matches" : "A senha digitada não corresponde",
			"Profile" : "Perfil",
			"Personal information" : "Informações pessoais",
			"User name" : "Nome do usuário",
			"Full name" : "Nome completo",
			"Email address" : "Endereço de email",
			"Language" : "Língua",
			"Photo" : "Foto",
			"Select authentication mode" : "Selecione o modo de autenticação",
			"Back to authentication modes" : "Voltar aos modos de autenticação",
			"Open" : "Libre",
			"User/password" : "Usuario/contraseña",
			"Digital certificate" : "Certificado digital",
			"It will use @firma application to login" : "Ele usará o aplicativo @firma para fazer login",
			"Loging in with @firma" : "Entrando com @firma",
			"Credential not found for %s" : "Credencial não encontrada para %s",
			"User unknown" : "Usuário desconhecido",
			"User/password invalid" : "Usuário/senha inválidos",
			"Save" : "Salve",
			"Link with certificate by using @firma" : "Link com certificado usando @firma",
			"Linking with @firma... follow steps in @firma app" : "Vinculando com @firma... siga os passos no aplicativo @firma",
			"Link" : "Vincular",
			"Linked with %s" : "Vinculado com %s",
			"Unlink" : "Desvincular",
			"Could not link your profile with certificate" : "Não foi possível vincular seu perfil ao certificado",
			"Select language" : "Selecione o idioma",
			"Password updated" : "Senha atualizada",
			"Active directory" : "Diretório ativo (LDAP)",
			"Language updated" : "Idioma atualizado",
			"Business unit" : "Unidade de negócio",
			"Logged in date" : "Data de login",
			"Online users" : "Usuários online",
			"No online users" : "Nenhum usuário on-line",
			"Refresh" : "Atualizar"
		},
		"es" : {
			"Affirm" : "Confirmar",
			"Sign" : "Firmar",
			"Cancel" : "Cancelar",
			"OK" : "Aceptar",
			"Back" : "Anterior",
			"Logout" : "Cerrar sesión",
			"Federation" : "Federación",
			"Next" : "Siguiente",
			"Value is out of range" : "Valor no permitido",
			"Search..." : "Buscar...",
			"no results" : "no hay elementos",
			"one result" : "un resultado",
			"results" : "resultados",
			"User not granted to execute operation" : "Permiso denegado. No puede ejecutar la operación",
			"Value is out of range" : "Valor no permitido",
			"User unknown" : "Usuario desconocido",
			"Loading application..." : "Cargando aplicación...",
			"Starting application..." : "Iniciando aplicación...",
			"Fill username" : "Indique su nombre de usuario",
			"Username" : "Nombre de usuario",
			"Fill password" : "Indique su contraseña",
			"Change password" : "Cambiar contraseña",
			"Password" : "Contraseña",
			"Type password" : "Escriba la contraseña",
			"Retype password" : "Repita la contraseña",
			"Log in" : "Iniciar sesión",
			"Fill valid username" : "Indique un nombre de usuario válido",
			"Wrong password" : "Contraseña incorrecta",
			"User unknown" : "Usuario no encontrado",
			"Under construction" : "En construcción",
			"Type password to save changes" : "Escriba una contraseña para guardar los cambios",
			"Typed password doesn't matches" : "La contraseña escrita no coincide",
			"Profile" : "Perfil",
			"Personal information" : "Información personal",
			"User name" : "Nombre de usuario",
			"Full name" : "Nombre completo",
			"Email address" : "Dirección de correo",
			"Language" : "Idioma",
			"Photo" : "Foto",
			"Select authentication mode" : "Seleccione un modo de autenticación",
			"Back to authentication modes" : "Volver a los modos de autenticación",
			"Open" : "Libre",
			"User/password" : "Usuario/contraseña",
			"Digital certificate" : "Certificado digital",
			"It will use @firma application to login" : "Se usará la aplicación @firma para iniciar sesión",
			"Loging in with @firma" : "Iniciando sesión con @firma",
			"Credential not found for %s" : "Credencial no encontrada para %s",
			"User unknown" : "Usuario desconocido",
			"User/password invalid" : "Usuario/contraseña inválido",
			"Save" : "Guardar",
			"Link with certificate by using @firma" : "Vincular con un certificado usando @firma",
			"Linking with @firma... follow steps in @firma app" : "Vinculando con @firma... siga los pasos en @firma",
			"Link" : "Vincular",
			"Linked with %s" : "Vinculado con %s",
			"Unlink" : "Desvincular",
			"Could not link your profile with certificate" : "No se ha podido vincular su perfil con el certificado",
			"Select language" : "Seleccione un idioma",
			"Password updated" : "Contraseña actualizada",
			"Active directory" : "Directorio activo (LDAP)",
			"Language updated" : "Idioma actualizado",
			"Business unit" : "Unidad de negocio",
			"Logged in date" : "Fecha de inicio",
			"Online users" : "Usuarios online",
			"No online users" : "No hay usuarios online",
			"Refresh" : "Refrescar"
		}
	};

    function merge(dictionary, lang) {
        if (dictionary == null) dictionary = {};
        addWords(dictionary, AlexandriaUiI18n.load(lang));
        return dictionary;
    };

    function addWords(dictionary, words) {
        if (words == null) return;
        for (var index in words) dictionary[index] = words[index];
        return dictionary;
    };

	var loader = {
		load: (lang) => {
            if (cache[lang] == null) cache[lang] = merge(translators[lang], lang);
            return cache[lang];
		}
	};

	return loader;
})();

export default I18n;