import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractLoginDialog from "../../../gen/displays/components/AbstractLoginDialog";
import LoginDialogNotifier from "../../../gen/displays/notifiers/LoginDialogNotifier";
import LoginDialogRequester from "../../../gen/displays/requesters/LoginDialogRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginDialog extends AbstractLoginDialog {

	constructor(props) {
		super(props);
		this.notifier = new LoginDialogNotifier(this);
		this.requester = new LoginDialogRequester(this);
	};


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginDialog));
DisplayFactory.register("LoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(LoginDialog)));