import React from "react";
import { withStyles } from '@material-ui/core/styles';
import AbstractGoogleLoginDialog from "../../gen/displays/AbstractGoogleLoginDialog";
import GoogleLoginDialogNotifier from "../../gen/displays/notifiers/GoogleLoginDialogNotifier";
import GoogleLoginDialogRequester from "../../gen/displays/requesters/GoogleLoginDialogRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class GoogleLoginDialog extends AbstractGoogleLoginDialog {

	constructor(props) {
		super(props);
		this.notifier = new GoogleLoginDialogNotifier(this);
		this.requester = new GoogleLoginDialogRequester(this);
	};

    render() {
        return (<div>Google</div>);
    };

}

export default withStyles(styles, { withTheme: true })(withSnackbar(GoogleLoginDialog));
DisplayFactory.register("GoogleLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(GoogleLoginDialog)));