import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiImageEditable from "alexandria-ui-elements/src/displays/components/ImageEditable";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiSelectorComboBox from "alexandria-ui-elements/src/displays/components/SelectorComboBox";
import UiMultiple from "alexandria-ui-elements/src/displays/components/Multiple";
import DisplaysOpenProfileDialog from "app-elements/gen/displays/templates/OpenProfileDialog";
import DisplaysPasswordProfileDialog from "app-elements/gen/displays/templates/PasswordProfileDialog";
import DisplaysCertificateProfileDialog from "app-elements/gen/displays/templates/CertificateProfileDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import ProfileTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import ProfileTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class ProfileTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new ProfileTemplateNotifier(this);
		this.requester = new ProfileTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766" format="block" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518" format="doubleAirBottom" layout="vertical" width="80.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a_2141495723" format="h4" mode="normal" translate={true} value="Personal information">
						</UiText>
						<UiImageEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a_1331771245" label="Photo" format="doubleAirTop" width="200px" height="300px">
						</UiImageEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a_209784007" label="User name" format="doubleAirTop" visible={false} mode="normal" readonly={true}>
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a_651216683" label="Full name" format="doubleAirTop" mode="normal">
						</UiTextEditable>
						<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a494505321" label="Email address" format="doubleAirTop" mode="normal">
						</UiTextEditable>
						<UiSelectorComboBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a1982350518.a_1815991817" label="Language" format="doubleAirTop" multipleSelection={false} placeholder="Select language" maxMenuHeight={300}>
						</UiSelectorComboBox>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a2042048629" format="doubleAirBottom" layout="vertical" width="80.0%" height="100.0%">
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a2042048629.a131069662" multiple={{instances:"openProfileDialogs",arrangement:"Vertical",noItemsMessage:"",spacing:32,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a2042048629.a_863371153" multiple={{instances:"passwordProfileDialogs",arrangement:"Vertical",noItemsMessage:"",spacing:32,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
						<UiMultiple context={this._context.bind(this)} owner={this._owner.bind(this)} id="a275859766.a2042048629.a_1368165433" multiple={{instances:"certificateProfileDialogs",arrangement:"Vertical",noItemsMessage:"",spacing:32,editable:false,wrap:true,collapsed:false,count:{min:0,max:-1}}}>
						</UiMultiple>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate));
DisplayFactory.register("ProfileTemplate", withStyles(styles, { withTheme: true })(withSnackbar(ProfileTemplate)));