import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import PasswordProfileDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import PasswordProfileDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class PasswordProfileDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new PasswordProfileDialogNotifier(this);
		this.requester = new PasswordProfileDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1090033008" format="h4" mode="normal">
				</UiText>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1521020759" label="Password" format="airTop" mode="normal" placeholder="Type password" type="password">
				</UiTextEditable>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_762293654" label="Retype password" format="airTop" mode="normal" placeholder="Retype password" type="password">
				</UiTextEditable>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1451434228" format="doubleAirTop" layout="horizontal">
					<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1451434228.a_300836880" title="Save" target="self" mode="Button" size="Small" highlighted="Outline">
					</UiAction>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(PasswordProfileDialog));
DisplayFactory.register("PasswordProfileDialog", withStyles(styles, { withTheme: true })(withSnackbar(PasswordProfileDialog)));