import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OpenProfileDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import OpenProfileDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OpenProfileDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OpenProfileDialogNotifier(this);
		this.requester = new OpenProfileDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" style={{...this.props.style,...display}}>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OpenProfileDialog));
DisplayFactory.register("OpenProfileDialog", withStyles(styles, { withTheme: true })(withSnackbar(OpenProfileDialog)));