import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OpenLoginDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import OpenLoginDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OpenLoginDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OpenLoginDialogNotifier(this);
		this.requester = new OpenLoginDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1037827085" label="Username" mode="normal" placeholder="Fill username" focused={true}>
				</UiTextEditable>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OpenLoginDialog));
DisplayFactory.register("OpenLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(OpenLoginDialog)));