import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTable from "alexandria-ui-elements/src/displays/components/Table";
import UiHeading from "alexandria-ui-elements/src/displays/components/Heading";
import UiSortingOrderBy from "alexandria-ui-elements/src/displays/components/SortingOrderBy";
import DisplaysOnlineUsersTableRow from "app-elements/gen/displays/rows/OnlineUsersTableRow";
import DisplaysOutUsernameItem from "app-elements/gen/displays/items/OutUsernameItem";
import DisplaysOutFullNameItem from "app-elements/gen/displays/items/OutFullNameItem";
import DisplaysOutEmailItem from "app-elements/gen/displays/items/OutEmailItem";
import DisplaysOutSpaceItem from "app-elements/gen/displays/items/OutSpaceItem";
import DisplaysOutLoggedInDateItem from "app-elements/gen/displays/items/OutLoggedInDateItem";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import OnlineUsersTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import OnlineUsersTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class OnlineUsersTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new OnlineUsersTemplateNotifier(this);
		this.requester = new OnlineUsersTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876" format="block" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154" format="doubleAirBottom" layout="vertical" width="80.0%" height="100.0%">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_891055081" format="h4 middleAirBottom" mode="normal" translate={true} value="Online users">
						</UiText>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a1777567748" format="airBottom" layout="horizontal">
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a1777567748.a999075935" title="Refresh" target="self" mode="Button" size="Small" highlighted="Outline">
							</UiAction>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890" format="whiteBackground" layout="vertical">
							<UiTable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490" format="whiteBackground" noItemsMessage="No online users" pageSize={20} itemHeight={20} scrollingMark={true}>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a1158804762" style={{width:"25%",paddingRight:"10px",paddingLeft:"10px"}} hidden="Never">
									<UiSortingOrderBy context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a1158804762.a457096873" label="Username" mode="asc" align="Left">
									</UiSortingOrderBy>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a324563859" style={{width:"25%",paddingRight:"10px"}} hidden="Never">
									<UiSortingOrderBy context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a324563859.a_1815578178" label="Full name" mode="asc" align="Left">
									</UiSortingOrderBy>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a_1906634733" style={{width:"15%",paddingRight:"10px"}} hidden="Never">
									<UiSortingOrderBy context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a_1906634733.a_1944392972" label="Email" mode="asc" align="Left">
									</UiSortingOrderBy>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a_788757332" style={{width:"15%",paddingRight:"10px"}} hidden="Never">
									<UiSortingOrderBy context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a_788757332.a_1627149459" label="Business unit" mode="asc" align="Left">
									</UiSortingOrderBy>
								</UiHeading>
								<UiHeading context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a1292790394" style={{width:"15%",paddingRight:"10px"}} hidden="Never">
									<UiSortingOrderBy context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1893982876.a_673548154.a_1369179890.a2060874490.a1292790394.a_742947464" label="Logged in date" mode="desc" align="Left">
									</UiSortingOrderBy>
								</UiHeading>
							</UiTable>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(OnlineUsersTemplate));
DisplayFactory.register("OnlineUsersTemplate", withStyles(styles, { withTheme: true })(withSnackbar(OnlineUsersTemplate)));