import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import DisplaysOpenLoginDialog from "app-elements/gen/displays/templates/OpenLoginDialog";
import DisplaysPasswordLoginDialog from "app-elements/gen/displays/templates/PasswordLoginDialog";
import DisplaysCertificateLoginDialog from "app-elements/gen/displays/templates/CertificateLoginDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LoginTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LoginTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LoginTemplateNotifier(this);
		this.requester = new LoginTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a69616461" format="backgroundLogin" visible={false}>
				</UiImage>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1660567969" format="backgroundDarkMode backgroundLogin" visible={false}>
				</UiImage>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839" format="grey" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a1405588210" layout="vertical flexible centercenter">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a1405588210.a_1585679336" mode="normal" value="Loading application...">
						</UiText>
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a1405588210.a1311738118" mode="Bar">
						</UiSpinner>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124" format="onTop" visible={false} layout="vertical" width="400px" height="360px" paper>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273" format="airLeft airRight relative" layout="vertical flexible centerjustified" width="calc(100% - 20px)" height="100.0%">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a1781616389" format="airBottom doubleAirTop" layout="vertical centercenter">
								<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a1781616389.a_508493430" width="-1px" height="70px" mobileReduceFactor={75}>
								</UiImage>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a1530310869" visible={false} layout="vertical flexible">
								<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a1530310869.a_1945640969" format="greyColor h5" mode="normal" translate={true} value="Select authentication mode">
								</UiText>
								<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a1530310869.a1737576737" multipleSelection={false}>
								</UiSelectorListBox>
							</UiBlock>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789" visible={false} layout="vertical flexible">
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a_234481804" format="airBottom" layout="horizontal">
									<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a_234481804.a_1093099855" title="Back to authentication modes" target="self" mode="MaterialIconButton" icon="ArrowBack" size="Small" format="airRight" visible={false}>
									</UiAction>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a_234481804.a2111848697" format="greyColor h5" mode="normal">
									</UiText>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857" layout="vertical flexible">
									<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a87009120" layout="vertical">
										<DisplaysOpenLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a87009120.a1385542280">
										</DisplaysOpenLoginDialog>
									</UiBlockConditional>
									<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a1976871665" layout="vertical">
										<DisplaysPasswordLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a1976871665.a839125544">
										</DisplaysPasswordLoginDialog>
									</UiBlockConditional>
									<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a1307534897" layout="vertical">
										<DisplaysCertificateLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a1307534897.a2137409992">
										</DisplaysCertificateLoginDialog>
									</UiBlockConditional>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a378265857.a_114912950" format="airTop loginError" mode="normal">
									</UiText>
								</UiBlock>
								<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a505592583">
								</UiDivider>
								<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1505134839.a837298124.a_2033473273.a467486789.a1742370561" title="Log in" target="self" mode="Button" size="Medium">
								</UiAction>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginTemplate));
DisplayFactory.register("LoginTemplate", withStyles(styles, { withTheme: true })(withSnackbar(LoginTemplate)));