import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import DisplaysOpenLoginDialog from "platform-elements/gen/displays/templates/OpenLoginDialog";
import DisplaysPasswordLoginDialog from "platform-elements/gen/displays/templates/PasswordLoginDialog";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import LoginDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import LoginDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class LoginDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new LoginDialogNotifier(this);
		this.requester = new LoginDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<DisplaysOpenLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1902575919">
				</DisplaysOpenLoginDialog>
				<DisplaysPasswordLoginDialog context={this._context.bind(this)} owner={this._owner.bind(this)} id="a478530724">
				</DisplaysPasswordLoginDialog>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(LoginDialog));
DisplayFactory.register("LoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(LoginDialog)));