import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiHeader from "alexandria-ui-elements/src/displays/components/Header";
import UiBlockDrawer from "alexandria-ui-elements/src/displays/components/BlockDrawer";
import UiOpenDrawer from "alexandria-ui-elements/src/displays/components/OpenDrawer";
import UiCloseDrawer from "alexandria-ui-elements/src/displays/components/CloseDrawer";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiSelectorListBox from "alexandria-ui-elements/src/displays/components/SelectorListBox";
import UiMaterialIcon from "alexandria-ui-elements/src/displays/components/MaterialIcon";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiBlockConditional from "alexandria-ui-elements/src/displays/components/BlockConditional";
import DisplaysHeader from "app-elements/gen/displays/templates/Header";
import DisplaysProfileTemplate from "app-elements/gen/displays/templates/ProfileTemplate";
import DisplaysOnlineUsersTemplate from "app-elements/gen/displays/templates/OnlineUsersTemplate";
import DisplaysFooter from "app-elements/gen/displays/templates/Footer";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HomeTemplateNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HomeTemplateRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class HomeTemplate extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HomeTemplateNotifier(this);
		this.requester = new HomeTemplateRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442" layout="vertical flexible">
					<UiHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a1578634798" format="airHeader separator" color="white" position="relative" width="-1px" height="65px" elevation={0}>
						<DisplaysHeader context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a1578634798.a_2139126776">
						</DisplaysHeader>
					</UiHeader>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357" layout="horizontal" width="100.0%" height="100.0%">
						<UiBlockDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938" layout="vertical" width="200px" height="-1px" position="Left" variant="PersistentAndMini">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a45526213" layout="horizontal endjustified center" width="-1px" height="60px">
								<UiOpenDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a45526213.a1822634251" title="open menu" target="self" mode="MaterialIconButton" icon="ChevronRight" size="Medium" format="airMenuRight">
								</UiOpenDrawer>
								<UiCloseDrawer context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a45526213.a_882096079" title="minimize" target="self" mode="MaterialIconButton" icon="ChevronLeft" size="Medium" format="airMenuRight">
								</UiCloseDrawer>
							</UiBlock>
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a1592472228">
							</UiDivider>
							<UiSelectorListBox context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069" multipleSelection={false}>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a1250580813" name="profile" format="smallAirLeft" layout="horizontal" spacing="16">
									<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a1250580813.a_1850171203" icon="PermIdentity">
									</UiMaterialIcon>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a1250580813.a1942959504" mode="normal" translate={true} value="Profile">
									</UiText>
								</UiBlock>
								<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a_257933031" name="onlineUsers" format="smallAirLeft" visible={false} layout="horizontal" spacing="16">
									<UiMaterialIcon context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a_257933031.a1663082758" icon="PeopleOutline">
									</UiMaterialIcon>
									<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a1660320938.a_2102871069.a_257933031.a_1041108612" mode="normal" translate={true} value="Online users">
									</UiText>
								</UiBlock>
							</UiSelectorListBox>
						</UiBlockDrawer>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481" layout="vertical flexible">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a970582275" layout="vertical flexible centercenter">
								<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a970582275.a523082459" format="secondary" mode="Rise">
								</UiSpinner>
							</UiBlock>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a_1854459873" layout="vertical flexible">
								<DisplaysProfileTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a_1854459873.a_2105831494">
								</DisplaysProfileTemplate>
							</UiBlockConditional>
							<UiBlockConditional context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a529418347" layout="vertical flexible">
								<DisplaysOnlineUsersTemplate context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a529418347.a_323653982">
								</DisplaysOnlineUsersTemplate>
							</UiBlockConditional>
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a1031849270" layout="vertical">
								<DisplaysFooter context={this._context.bind(this)} owner={this._owner.bind(this)} id="a197952442.a2000484357.a372335481.a1031849270.a_1508945446">
								</DisplaysFooter>
							</UiBlock>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate));
DisplayFactory.register("HomeTemplate", withStyles(styles, { withTheme: true })(withSnackbar(HomeTemplate)));