import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiAppDirectory from "alexandria-ui-elements/src/displays/components/AppDirectory";
import UiUser from "alexandria-ui-elements/src/displays/components/User";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import HeaderNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import HeaderRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class Header extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new HeaderNotifier(this);
		this.requester = new HeaderRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="horizontal center" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1527542245" layout="horizontal center flexible" spacing="8">
					<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1527542245.a_1206116138" format="autoWidth" width="-1px" height="50px">
					</UiImage>
					<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1527542245.a1272327309" format="appTitleStyle h3" mode="normal" value="Amidas">
					</UiText>
				</UiBlock>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1672307622" format="h6 secondary" layout="horizontal center endjustified" spacing="16">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1672307622.a_1200001575" format="middleAirRight" visible={false} layout="vertical">
						<UiAppDirectory context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1672307622.a_1200001575.a901620789" icon="Apps">
						</UiAppDirectory>
					</UiBlock>
					<UiUser context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1672307622.a_1487952671" color="grey" mode="OnlyPhoto">
					</UiUser>
				</UiBlock>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(Header));
DisplayFactory.register("Header", withStyles(styles, { withTheme: true })(withSnackbar(Header)));