import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSignText from "alexandria-ui-elements/src/displays/components/SignText";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CertificateLoginDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CertificateLoginDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CertificateLoginDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CertificateLoginDialogNotifier(this);
		this.requester = new CertificateLoginDialogRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2073219940" mode="normal" translate={true} value="It will use @firma application to login">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1602259672" visible={false} mode="normal" translate={true} value="Loging in with @firma">
				</UiText>
				<UiSignText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1583390958" title="Sign" target="self" mode="Button" size="Medium" visible={false} signFormat="XAdES">
				</UiSignText>
			</UiBlock>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(CertificateLoginDialog));
DisplayFactory.register("CertificateLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(CertificateLoginDialog)));