import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import CasLoginDialogNotifier from "alexandria-ui-elements/gen/displays/notifiers/TemplateNotifier";
import CasLoginDialogRequester from "alexandria-ui-elements/gen/displays/requesters/TemplateRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class CasLoginDialog extends UiTemplate {

	constructor(props) {
		super(props);
		this.notifier = new CasLoginDialogNotifier(this);
		this.requester = new CasLoginDialogRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a58626892" format="h5" mode="normal" translate={true} value="Loging in...">
				</UiText>
				<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_151402495" format="h5" mode="normal" translate={true} value="Logged as">
				</UiText>
			</UiBlock>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(CasLoginDialog));
DisplayFactory.register("CasLoginDialog", withStyles(styles, { withTheme: true })(withSnackbar(CasLoginDialog)));