import React from "react";
import UiImage from "alexandria-ui-elements/src/displays/components/Image";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiText from "alexandria-ui-elements/src/displays/components/Text";
import UiSpinner from "alexandria-ui-elements/src/displays/components/Spinner";
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiDivider from "alexandria-ui-elements/src/displays/components/Divider";
import UiAction from "alexandria-ui-elements/src/displays/components/Action";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractLoginTemplate extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock layout="vertical flexible" width="100.0%" height="100.0%" style={{...this.props.style,...display}}>
				<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_112449719" format="backgroundLogin" visible={false}>
				</UiImage>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a444469410" format="grey" layout="vertical centercenter" width="100.0%" height="100.0%">
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_847242378" layout="vertical flexible centercenter">
						<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1306088212" mode="normal" value="Loading application...">
						</UiText>
						<UiSpinner context={this._context.bind(this)} owner={this._owner.bind(this)} id="a676758735" mode="Bar">
						</UiSpinner>
					</UiBlock>
					<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_897941816" format="onTop" visible={false} layout="vertical" width="400px" height="360px" paper>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a2074842349" format="relative" layout="vertical flexible centerjustified" width="100.0%" height="100.0%" spacing="16">
							<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1117679091" layout="vertical centercenter">
								<UiImage context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1110199822">
								</UiImage>
							</UiBlock>
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1912897648" label="Nombre usuario" mode="normal" placeholder="Indique su nombre de usuario" focused={true}>
							</UiTextEditable>
							<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_899370443" label="Contraseña" mode="normal" placeholder="Indique su contraseña" type="password">
							</UiTextEditable>
							<UiText context={this._context.bind(this)} owner={this._owner.bind(this)} id="a271880366" format="loginError airTop" mode="normal">
							</UiText>
						</UiBlock>
						<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a439265310" layout="vertical">
							<UiDivider context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1249649694">
							</UiDivider>
							<UiAction context={this._context.bind(this)} owner={this._owner.bind(this)} id="a335802108" title="Iniciar sesión" target="self" mode="Button" size="Medium">
							</UiAction>
						</UiBlock>
					</UiBlock>
				</UiBlock>
			</UiBlock>
		);
	}
}