import React from "react";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import UiOpenSite from "alexandria-ui-elements/src/displays/components/OpenSite";
import UiTemplate from "alexandria-ui-elements/src/displays/components/Template";
import Notifier from "../notifiers/Notifier";
import Requester from "../requesters/Requester";

export default class AbstractFooter extends UiTemplate {

	constructor(props) {
		super(props);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
		return(
			<UiBlock format="footerFormat" layout="vertical" style={{...this.props.style,...display}}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_235871546" layout="horizontal flexible endjustified">
					<UiOpenSite context={this._context.bind(this)} owner={this._owner.bind(this)} id="a_1862136926" title="powered by intino" target="blank" mode="Link" size="Medium" format="body2">
					</UiOpenSite>
				</UiBlock>
			</UiBlock>
		);
	}
}