package io.intino.amidas.accessor.adapters.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.intino.alexandria.ui.services.auth.UserInfo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class UserInfoResponseAdapter extends ObjectResponseAdapter<UserInfo> {

    @Override
    protected UserInfo adapt(JsonObject element) {
        return new UserInfo() {
            @Override
            public String username() {
                return element.get("name").getAsString();
            }

            @Override
            public String fullName() {
                return element.get("title").getAsString();
            }

            @Override
            public URL photo() {
                try {
                    return new URL(element.get("image").getAsString());
                } catch (MalformedURLException e) {
                    return null;
                }
            }

            @Override
            public String email() {
                return element.get("email").getAsString();
            }

            @Override
            public String language() {
                return element.get("language").getAsString();
            }

            @Override
            public List<String> roleList() {
                JsonArray roleList = element.get("roleList").getAsJsonArray();
                List<String> result = new ArrayList<>();
                roleList.forEach(r -> result.add(r.getAsString()));
                return result;
            }
        };
    }

}
