package io.intino.amidas.accessor;

import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.amidas.accessor.core.Amidas;
import io.intino.amidas.accessor.core.AmidasInfo;
import io.intino.amidas.accessor.core.Space;
import io.intino.amidas.accessor.core.Verifier;
import io.intino.amidas.accessor.core.exceptions.AmidasApiFailure;
import io.intino.amidas.accessor.core.exceptions.SpaceAuthenticateCallbackUrlIsNull;

import java.net.URL;

public interface AmidasApi {

    Authenticating authenticate(Amidas amidas);
    boolean valid(Amidas amidas, Token accessToken) throws AmidasApiFailure;
    AmidasInfo info(Amidas amidas, Token accessToken) throws AmidasApiFailure;
    UserInfo me(Amidas amidas, Token accessToken) throws AmidasApiFailure;
    void logout(Amidas amidas, Token accessToken) throws AmidasApiFailure;

    void addPushListener(Amidas amidas, Token accessToken, AmidasPushListener listener) throws AmidasApiFailure;

    interface Authenticating {
        Authentication with(Space space) throws SpaceAuthenticateCallbackUrlIsNull;

        interface Authentication {
            Token requestToken() throws CouldNotObtainRequestToken;
            URL authenticationUrl(Token requestToken) throws CouldNotObtainAuthorizationUrl;
            Token accessToken();
            Token accessToken(Verifier verifier) throws CouldNotObtainAccessToken;
            void invalidate() throws AmidasApiFailure;
        }
    }

    interface AmidasPushListener {
        void userLoggedOut(UserInfo user);
        void userAdded(UserInfo user);
    }

}
