/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor;

import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.auth.Space;
import io.intino.amidas.accessor.alexandria.core.AmidasAzureAccessor;
import io.intino.amidas.accessor.alexandria.core.AmidasCasAccessor;
import io.intino.amidas.accessor.alexandria.core.AmidasOauthAccessor;
import io.intino.amidas.accessor.core.Configuration;
import io.intino.amidas.accessor.core.Provider;
import java.net.URL;
import java.util.Properties;

public class AuthServiceProvider {
    private final Space space;

    public AuthServiceProvider(Space space) {
        this.space = space;
    }

    public AuthService authService(Properties properties) {
        Configuration configuration = new Configuration(properties);
        URL url = configuration.url();
        if (url == null) {
            return null;
        }
        Provider provider = configuration.provider();
        if (provider == Provider.CAS) {
            return new AmidasCasAccessor(this.space, url);
        }
        if (provider == Provider.Amidas) {
            return new AmidasOauthAccessor(this.space, url);
        }
        if (provider == Provider.Azure) {
            return new AmidasAzureAccessor(this.space, new Configuration(properties));
        }
        return null;
    }
}

