package io.intino.amidas.accessor.utils;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import static org.apache.http.impl.client.HttpClientBuilder.create;

public class RequestHelper {

    public static URL post(URL url) throws IOException {
        HttpPost post = new HttpPost(url.toString());

        try (CloseableHttpClient client = create().build()){
            return getPostUrl(client.execute(post));
        }
    }

    private static URL getPostUrl(HttpResponse response) throws IOException {
        if (response.getStatusLine().getStatusCode() == 302)
			return toUrl(response.getFirstHeader("Location").getValue().getBytes());
        return toUrl(toByteArray(response.getEntity().getContent()));
    }

    private static byte[] toByteArray(InputStream content) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int read;
        while ((read = content.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    private static URL toUrl(byte[] bytes) throws IOException {
        return new URL(new String(bytes));
    }
}