package io.intino.amidas.accessor.alexandria.adapters.response;

import io.intino.amidas.accessor.adapters.response.ObjectResponseAdapter;
import com.google.gson.JsonObject;
import io.intino.alexandria.ui.services.auth.FederationInfo;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class FederationInfoResponseAdapter extends ObjectResponseAdapter<FederationInfo> {

    @Override
    protected FederationInfo adapt(JsonObject element) {
        return new FederationInfo() {
            @Override
            public String name() {
                return element.get("name").getAsString();
            }

            @Override
            public String title() {
                return element.get("title").getAsString();
            }

            @Override
            public String subtitle() {
                return element.get("subtitle").getAsString();
            }

            @Override
            public URL logo() {
                try {
                    return new URL(element.get("logo").getAsString());
                } catch (MalformedURLException e) {
                    return null;
                }
            }

            @Override
            public URI pushServerUri() {
                return URI.create(element.get("pushServerUri").getAsString());
            }
        };
    }

}
