package io.intino.amidas.accessor;

import io.intino.alexandria.ui.services.auth.Token;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.amidas.accessor.core.Amidas;
import io.intino.amidas.accessor.core.AmidasInfo;
import io.intino.amidas.accessor.core.Parameter;
import io.intino.amidas.accessor.core.exceptions.AmidasApiFailure;
import io.intino.amidas.accessor.core.exceptions.CouldNotValidateSignature;

import java.net.URL;
import java.util.List;

public interface AmidasSetupApi {

    boolean validate(Amidas amidas, String signature, String hash) throws AmidasApiFailure, CouldNotValidateSignature;
    Connection connect(Amidas amidas);
    Connection connect(Amidas amidas, URL certificate, String password);

    interface Connection {
        boolean ping();
        AmidasInfo info() throws AmidasApiFailure;
        UserInfo user(String username, String email) throws AmidasApiFailure;
        UserInfo user(Token token) throws AmidasApiFailure;
        UserInfo user(String authentication, List<Parameter> parameters) throws AmidasApiFailure;
    }

}
