/*
 * Decompiled with CFR 0.152.
 */
package io.intino.amidas.accessor.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.intino.alexandria.restaccessor.Response;
import io.intino.alexandria.restaccessor.RestAccessor;
import io.intino.alexandria.restaccessor.exceptions.RestfulFailure;
import io.intino.alexandria.ui.services.auth.UserInfo;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAccessToken;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainAuthorizationUrl;
import io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainRequestToken;
import io.intino.amidas.accessor.AmidasApi;
import io.intino.amidas.accessor.AmidasSetupApi;
import io.intino.amidas.accessor.adapters.request.ParameterRequestAdapter;
import io.intino.amidas.accessor.adapters.response.AmidasInfoResponseAdapter;
import io.intino.amidas.accessor.adapters.response.UserInfoResponseAdapter;
import io.intino.amidas.accessor.core.Amidas;
import io.intino.amidas.accessor.core.AmidasInfo;
import io.intino.amidas.accessor.core.Parameter;
import io.intino.amidas.accessor.core.PushClient;
import io.intino.amidas.accessor.core.Space;
import io.intino.amidas.accessor.core.Verifier;
import io.intino.amidas.accessor.core.exceptions.AmidasApiFailure;
import io.intino.amidas.accessor.core.exceptions.SpaceAuthenticateCallbackUrlIsNull;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.Api;
import org.scribe.builder.api.DefaultApi10a;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class AmidasProxy
implements AmidasApi,
AmidasSetupApi {
    private Map<Amidas, PushClient> pushClientMap = new HashMap<Amidas, PushClient>();
    private RestAccessor api = new io.intino.alexandria.restaccessor.core.RestAccessor();
    private static final String ResponseOk = "OK";

    @Override
    public AmidasApi.Authenticating authenticate(final Amidas amidas) {
        return space -> new AmidasApi.Authenticating.Authentication(){
            private OAuthService authService;
            private io.intino.alexandria.ui.services.auth.Token requestToken;
            private io.intino.alexandria.ui.services.auth.Token accessToken;
            {
                this.authService = AmidasProxy.this.serviceOf(amidas, space);
            }

            @Override
            public io.intino.alexandria.ui.services.auth.Token requestToken() throws CouldNotObtainRequestToken {
                try {
                    this.requestToken = AmidasProxy.this.tokenFrom(Optional.of(this.authService.getRequestToken()));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainRequestToken(exception);
                }
                this.accessToken = null;
                return this.requestToken;
            }

            @Override
            public URL authenticationUrl(io.intino.alexandria.ui.services.auth.Token requestToken) throws CouldNotObtainAuthorizationUrl {
                if (this.requestToken != requestToken) {
                    return null;
                }
                try {
                    return new URL(this.authService.getAuthorizationUrl(AmidasProxy.this.token(Optional.of(requestToken))));
                }
                catch (Exception e) {
                    throw new CouldNotObtainAuthorizationUrl(e);
                }
            }

            @Override
            public io.intino.alexandria.ui.services.auth.Token accessToken() {
                return this.accessToken;
            }

            @Override
            public io.intino.alexandria.ui.services.auth.Token accessToken(Verifier verifier) throws CouldNotObtainAccessToken {
                if (this.requestToken == null) {
                    return null;
                }
                try {
                    Token accessToken = this.authService.getAccessToken(AmidasProxy.this.token(Optional.of(this.requestToken)), AmidasProxy.this.verifier(verifier));
                    this.accessToken = AmidasProxy.this.tokenFrom(Optional.of(accessToken));
                }
                catch (Exception exception) {
                    throw new CouldNotObtainAccessToken(exception);
                }
                return this.accessToken;
            }

            @Override
            public void invalidate() throws AmidasApiFailure {
                try {
                    AmidasProxy.this.api.post(amidas.url(), String.format("/api/invalidate/%s", this.accessToken.id()));
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not invalidate token %s", this.accessToken.id()));
                }
            }
        };
    }

    @Override
    public boolean valid(Amidas amidas, io.intino.alexandria.ui.services.auth.Token accessToken) throws AmidasApiFailure {
        try {
            return this.getAndCheck(amidas.url(), String.format("/api/valid/%s", accessToken.id()));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public AmidasInfo info(Amidas amidas, io.intino.alexandria.ui.services.auth.Token accessToken) throws AmidasApiFailure {
        try {
            Response response = this.api.get(amidas.url(), String.format("/api/info/%s", accessToken.id()));
            return (AmidasInfo)new AmidasInfoResponseAdapter().adapt(response.content());
        }
        catch (Exception exception) {
            throw new AmidasApiFailure(String.format("Could not receive amidas info with token %s", accessToken.id()));
        }
    }

    @Override
    public UserInfo me(Amidas amidas, io.intino.alexandria.ui.services.auth.Token accessToken) throws AmidasApiFailure {
        try {
            Response response = this.api.get(amidas.url(), String.format("/api/me/%s", accessToken.id()));
            return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
        }
        catch (RestfulFailure failure) {
            throw new AmidasApiFailure(String.format("Could not receive user info with token %s", accessToken.id()));
        }
    }

    @Override
    public void logout(Amidas amidas, io.intino.alexandria.ui.services.auth.Token accessToken) throws AmidasApiFailure {
        try {
            this.api.post(amidas.url(), String.format("/api/logout/%s", accessToken.id()));
        }
        catch (Exception e) {
            throw new AmidasApiFailure(String.format("Could not logout with token %s", accessToken.id()));
        }
    }

    @Override
    public void addPushListener(Amidas amidas, io.intino.alexandria.ui.services.auth.Token accessToken, AmidasApi.AmidasPushListener listener) throws AmidasApiFailure {
        if (!this.pushClientMap.containsKey(amidas)) {
            AmidasInfo info = this.info(amidas, accessToken);
            this.pushClientMap.put(amidas, this.createPushClient(info));
        }
        PushClient pushClient = this.pushClientMap.get(amidas);
        pushClient.addListener(listener);
    }

    @Override
    public boolean validate(Amidas amidas, final String signature, final String hash) throws AmidasApiFailure {
        try {
            Response response = this.api.post(amidas.url(), "/signature", (Map)new HashMap<String, String>(){
                {
                    this.put("operation", "validate");
                    this.put("signature", signature);
                    this.put("hash", hash);
                }
            });
            return response.content().equals(ResponseOk);
        }
        catch (Exception e) {
            throw new AmidasApiFailure("Could not validate signature");
        }
    }

    @Override
    public AmidasSetupApi.Connection connect(Amidas amidas) {
        return this.connect(amidas, null, null);
    }

    @Override
    public AmidasSetupApi.Connection connect(final Amidas amidas, final URL certificate, final String password) {
        return new AmidasSetupApi.Connection(){
            private RestAccessor.RestfulSecureConnection connection = null;

            @Override
            public boolean ping() {
                try {
                    Response response = this.secure().get("/ping");
                    return response.content().equals(AmidasProxy.ResponseOk);
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            public AmidasInfo info() throws AmidasApiFailure {
                try {
                    Response response = this.secure().get("/info");
                    return (AmidasInfo)new AmidasInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure("Could not load amidas info");
                }
            }

            @Override
            public UserInfo user(final String username, final String email) throws AmidasApiFailure {
                try {
                    Response response = this.secure().get("/user/info", (Map)new HashMap<String, String>(){
                        {
                            this.put("username", username);
                            this.put("email", email);
                        }
                    });
                    return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not load user info of %s with email %s", username, email));
                }
            }

            @Override
            public UserInfo user(final io.intino.alexandria.ui.services.auth.Token token) throws AmidasApiFailure {
                try {
                    Response response = this.secure().get("/user/with-token", (Map)new HashMap<String, String>(){
                        {
                            this.put("token", token.id());
                        }
                    });
                    return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not load user info from token %s", token));
                }
            }

            @Override
            public UserInfo user(final String authentication, final List<Parameter> parameters) throws AmidasApiFailure {
                try {
                    Response response = this.secure().post("/user/with-credential", (Map)new HashMap<String, String>(){
                        {
                            this.put("authentication", authentication);
                            this.put("parameters", new ParameterRequestAdapter().adaptList(parameters).toString());
                        }
                    });
                    return (UserInfo)new UserInfoResponseAdapter().adapt(response.content());
                }
                catch (Exception e) {
                    throw new AmidasApiFailure(String.format("Could not validate user for authentication %s", authentication));
                }
            }

            private RestAccessor.RestfulSecureConnection secure() {
                if (this.connection == null) {
                    this.connection = AmidasProxy.this.api.secure(amidas.url(), certificate, password);
                }
                return this.connection;
            }
        };
    }

    private PushClient createPushClient(AmidasInfo info) {
        return new AmidasPushClient(info);
    }

    private io.intino.alexandria.ui.services.auth.Token tokenFrom(final Optional<Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new io.intino.alexandria.ui.services.auth.Token(){

            public String id() {
                return ((Token)token.get()).getToken();
            }

            public String secret() {
                return ((Token)token.get()).getSecret();
            }
        };
    }

    private Token token(Optional<io.intino.alexandria.ui.services.auth.Token> token) {
        if (!token.isPresent()) {
            return null;
        }
        return new Token(token.get().id(), "");
    }

    private org.scribe.model.Verifier verifier(Verifier verifier) {
        return new org.scribe.model.Verifier(verifier.value());
    }

    private OAuthService serviceOf(Amidas amidas, Space space) throws SpaceAuthenticateCallbackUrlIsNull {
        ServiceBuilder builder = new ServiceBuilder().provider(this.apiOf(amidas)).apiKey(space.name()).apiSecret(space.secret());
        URL callbackUrl = space.authenticateCallbackUrl();
        if (callbackUrl == null) {
            throw new SpaceAuthenticateCallbackUrlIsNull();
        }
        builder.callback(callbackUrl.toString());
        return builder.build();
    }

    private Api apiOf(Amidas amidas) {
        String AuthenticationPath = "/authentication/%s";
        String RequestTokenPath = "/authentication/token/request";
        String AccessTokenPath = "/authentication/token/access";
        final String url = amidas.url().toString();
        return new DefaultApi10a(){

            public String getRequestTokenEndpoint() {
                return url + "/authentication/token/request";
            }

            public String getAccessTokenEndpoint() {
                return url + "/authentication/token/access";
            }

            public String getAuthorizationUrl(Token token) {
                return url + String.format("/authentication/%s", token.getToken());
            }
        };
    }

    private boolean getAndCheck(URL url, String resource) throws RestfulFailure {
        return Boolean.valueOf(this.api.get(url, resource).content());
    }

    private static class AmidasPushClient
    implements PushClient {
        private final AmidasInfo info;
        private WebSocketClient client;
        private List<AmidasApi.AmidasPushListener> listenerList;

        public AmidasPushClient(AmidasInfo info) {
            this.info = info;
            this.listenerList = new ArrayList<AmidasApi.AmidasPushListener>();
            this.createClient();
        }

        private void createClient() {
            this.client = new WebSocketClient(this.info.pushServerUri()){

                public void onOpen(ServerHandshake serverHandshake) {
                    System.out.println("connection opened with server");
                }

                public void onMessage(String message) {
                    this.notify(message);
                }

                public void onClose(int i, String s, boolean b) {
                }

                public void onError(Exception e) {
                }
            };
            this.client.connect();
        }

        @Override
        public void notify(String rawMessage) {
            Message message = this.messageOf(rawMessage);
            if (!rawMessage.contains("userLoggedOut") && !rawMessage.contains("userAdded")) {
                return;
            }
            for (AmidasApi.AmidasPushListener listener : this.listenerList) {
                if (!message.name.equals("userLoggedOut")) continue;
                listener.userLoggedOut((UserInfo)new UserInfoResponseAdapter().adapt(message.param("userInfo")));
            }
        }

        private Message messageOf(String rawMessage) {
            return Message.build(rawMessage);
        }

        @Override
        public void addListener(AmidasApi.AmidasPushListener listener) {
            this.listenerList.add(listener);
        }

        private static class Message {
            private String name;
            private JsonObject rawParameters;

            public Message(String name) {
                this.name = name;
            }

            public String name() {
                return this.name;
            }

            public JsonElement param(String name) {
                if (this.rawParameters == null) {
                    return null;
                }
                return this.rawParameters.get(name);
            }

            public static Message build(String rawData) {
                JsonElement raw = new JsonParser().parse(rawData);
                if (raw instanceof JsonPrimitive) {
                    return new Message(raw.getAsString());
                }
                JsonObject rawMessage = (JsonObject)raw;
                Message message = new Message(rawMessage.get("name").getAsString());
                message.rawParameters = rawMessage.get("parameters").getAsJsonObject();
                return message;
            }
        }
    }
}

