package io.intino.amidas.accessor.core;

import java.util.*;

public class Facet {
    private String name;
    private Map<String, List<String>> parameters;

    public Facet(String name) {
        this.name = name;
        this.parameters = new HashMap<>();
    }

    public String name() {
        return name;
    }

    public Map<String, List<String>> parameters() {
        return parameters;
    }

    public void set(String name, String... values) {
        this.parameters.put(name, Arrays.asList(values));
    }

    public void set(String name, List<String> valueList) {
        this.parameters.put(name, valueList);
    }
}
