package io.intino.amidas.accessor.adapters.response;

import com.google.gson.*;

import java.util.ArrayList;
import java.util.List;

public abstract class ObjectResponseAdapter<T> implements ResponseAdapter<T> {

    @Override
    public T adapt(String jsonContent) {
        JsonElement element = (new JsonParser()).parse(jsonContent);
        return adapt((JsonObject)element);
    }

    @Override
    public T adapt(Object jsonObject) {
        return adapt((JsonObject)jsonObject);
    }

    @Override
    public List<T> adaptList(String jsonContent) {
        JsonElement element = (new JsonParser()).parse(jsonContent);
        return adaptList((JsonArray)element);
    }

    protected abstract T adapt(JsonObject element);

    private List<T> adaptList(JsonArray elements) {
        List<T> result = new ArrayList<>();
        for (JsonElement element : elements) result.add(adapt((JsonObject) element));
        return result;
    }
}
