package io.intino.amidas.accessor.adapters.request;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.intino.amidas.accessor.core.Parameter;

import java.util.List;

public class ParameterRequestAdapter implements RequestAdapter<Parameter> {
    @Override
    public JsonObject adapt(Parameter object) {
        JsonObject result = new JsonObject();
        result.addProperty("name", encode(object.name()));
        result.addProperty("value", encode(object.value()));
        return result;
    }

    public JsonArray adaptList(List<Parameter> parameters) {
        JsonArray result = new JsonArray();
        parameters.forEach(p -> result.add(adapt(p)));
        return result;
    }

}
