package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.ui.displays.components.BlockResizable;
import io.intino.alexandria.exceptions.*;
import io.intino.alexandria.*;
import io.intino.alexandria.schemas.*;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.server.AlexandriaUiManager;

public class BlockResizableRequester extends io.intino.alexandria.ui.displays.requesters.ComponentRequester {

	public BlockResizableRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
		super(manager, notifierProvider);
	}

	@Override
	public void execute() throws AlexandriaException {
		BlockResizable display = display();
		if (display == null) return;
		String operation = operation();

		if (operation.equals("layoutModified")) {
			display.layoutModified(java.util.List.of(io.intino.alexandria.Json.fromString(manager.fromQuery("v"), Double[].class)));
			return;
		}

		super.execute();
	}
}