/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.model.chat;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class Message {
    private Instant ts;
    private Direction direction;
    private String content;
    private boolean active = false;
    private List<String> attachments = new ArrayList<String>();

    public static Message with(String content, Direction direction) {
        return Message.with(content, direction, new ArrayList<String>());
    }

    public static Message with(String content, Direction direction, List<String> attachments) {
        return new Message().ts(Instant.now()).content(content).direction(direction).attachments(attachments);
    }

    public Instant ts() {
        return this.ts;
    }

    public Message ts(Instant ts) {
        this.ts = ts;
        return this;
    }

    public Direction direction() {
        return this.direction;
    }

    public Message direction(Direction direction) {
        this.direction = direction;
        return this;
    }

    public String content() {
        return this.content;
    }

    public Message content(String content) {
        this.content = content;
        return this;
    }

    public boolean active() {
        return this.active;
    }

    public Message active(boolean active) {
        this.active = active;
        return this;
    }

    public List<String> attachments() {
        return this.attachments;
    }

    public Message attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public static enum Direction {
        Incoming,
        Outgoing;

    }
}

