/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.requesters;

import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.ui.displays.components.DateNavigator;
import io.intino.alexandria.ui.displays.notifiers.DisplayNotifierProvider;
import io.intino.alexandria.ui.displays.requesters.ComponentRequester;
import io.intino.alexandria.ui.server.AlexandriaUiManager;
import java.time.Instant;

public class DateNavigatorRequester
extends ComponentRequester {
    public DateNavigatorRequester(AlexandriaUiManager manager, DisplayNotifierProvider notifierProvider) {
        super(manager, notifierProvider);
    }

    @Override
    public void execute() throws AlexandriaException {
        DateNavigator display = (DateNavigator)this.display();
        if (display == null) {
            return;
        }
        String operation = this.operation();
        if (operation.equals("first")) {
            display.first();
            return;
        }
        if (operation.equals("previous")) {
            display.previous();
            return;
        }
        if (operation.equals("next")) {
            display.next();
            return;
        }
        if (operation.equals("last")) {
            display.last();
            return;
        }
        if (operation.equals("select")) {
            display.select(this.manager.fromQuery("v") != null ? Instant.ofEpochMilli(Long.parseLong(this.manager.fromQuery("v"))) : null);
            return;
        }
        if (operation.equals("changeScale")) {
            display.changeScale(this.manager.fromQuery("v"));
            return;
        }
        super.execute();
    }
}

