/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.SelectorTabsOptionVisibility;
import io.intino.alexandria.ui.displays.components.AbstractSelectorTabs;
import io.intino.alexandria.ui.displays.components.selector.SelectorOption;
import io.intino.alexandria.ui.displays.notifiers.SelectorTabsNotifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SelectorTabs<DN extends SelectorTabsNotifier, B extends Box>
extends AbstractSelectorTabs<DN, B> {
    private int selected = -1;

    public SelectorTabs(B box) {
        super(box);
    }

    @Override
    public void didMount() {
        super.didMount();
        this.selection(this.selected);
    }

    public List<String> selection() {
        if (this.selected == -1) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.nameOf(this.selected));
    }

    public void selection(String option) {
        int position = this.position(option);
        if (position == -1) {
            return;
        }
        this.selection(position);
    }

    public void selection(int option) {
        ((SelectorTabsNotifier)this.notifier).refreshSelected(option);
        if (this.selected == option) {
            return;
        }
        this.selected = option;
    }

    public void select(String option) {
        this.selection(option);
        this.notifySelection();
    }

    public void selectByName(String option) {
        this.select(option);
    }

    public void select(int option) {
        this.selection(option);
        this.notifySelection();
    }

    public void showOption(String option) {
        this.hiddenOptions.remove(option);
        ((SelectorTabsNotifier)this.notifier).refreshOptionsVisibility(this.optionsVisibility());
    }

    public void hideOption(String option) {
        this.hiddenOptions.add(option);
        ((SelectorTabsNotifier)this.notifier).refreshOptionsVisibility(this.optionsVisibility());
    }

    public void show(String option) {
        SelectorOption component = this.findOption(this.position(option));
        component.visible(true);
    }

    public void hide(String option) {
        SelectorOption component = this.findOption(this.position(option));
        component.visible(false);
    }

    @Override
    public void reset() {
        this.selected = -1;
        ((SelectorTabsNotifier)this.notifier).refreshSelected(null);
    }

    private List<SelectorTabsOptionVisibility> optionsVisibility() {
        ArrayList<SelectorTabsOptionVisibility> result = new ArrayList<SelectorTabsOptionVisibility>();
        List<SelectorOption> options = this.options();
        for (int i = 0; i < options.size(); ++i) {
            result.add(new SelectorTabsOptionVisibility().index(i).visible(!this.hiddenOptions.contains(options.get(i).name())));
        }
        return result;
    }
}

