/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.displays.components;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.schemas.BlockResizableVisibility;
import io.intino.alexandria.ui.displays.components.AbstractBlockResizable;
import io.intino.alexandria.ui.displays.events.LayoutChangedEvent;
import io.intino.alexandria.ui.displays.events.LayoutChangedListener;
import io.intino.alexandria.ui.displays.notifiers.BlockResizableNotifier;
import java.util.List;

public class BlockResizable<DN extends BlockResizableNotifier, B extends Box>
extends AbstractBlockResizable<B> {
    private LayoutChangedListener layoutChangedListener;

    public BlockResizable(B box) {
        super(box);
    }

    public void onLayoutChanged(LayoutChangedListener listener) {
        this.layoutChangedListener = listener;
    }

    public void refreshLayout(Double ... percentages) {
        ((BlockResizableNotifier)this.notifier).refreshLayout(List.of(percentages));
    }

    public void layoutModified(List<Double> percentages) {
        if (this.layoutChangedListener == null) {
            return;
        }
        this.layoutChangedListener.accept(new LayoutChangedEvent(this, percentages));
    }

    protected void refreshVisibility(String child, boolean visible) {
        ((BlockResizableNotifier)this.notifier).refreshChildVisibility(new BlockResizableVisibility().child(child).visible(visible));
    }
}

