/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model.data;

import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.ui.documentation.Model;
import io.intino.alexandria.ui.documentation.model.BaseWidget;
import java.util.Arrays;
import java.util.Collections;

public class ImageWidget
extends BaseWidget {
    public ImageWidget() {
        super("This widget allows preview images or create avatars from text.");
        this.facets(Arrays.asList("Avatar", "Absolute", "Relative", "Editable"));
    }

    @Override
    protected void addProperties() {
        super.addProperties();
        this.add(Model.property("value", Property.Type.Text, "Image for widget. It must be a resource directory relative path to image.", new String[0]));
        this.add(Model.property("defaultValue", Property.Type.Text, "Default image for widget if value is not present.", new String[0]));
        this.add(Model.property("text", Property.Type.Text, "Text used to create avatar image. It uses initial letters of text.", new String[0]).facets(Collections.singletonList("Avatar")));
        this.add(Model.property("width", Property.Type.Integer, "Width of image in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
        this.add(Model.property("height", Property.Type.Integer, "Height of image in pixels with Absolute facet or percentage with Relative facet", new String[0]).facets(Arrays.asList("Absolute", "Relative")));
    }

    @Override
    protected void addMethods() {
        super.addMethods();
        this.addMethod(Model.method("value", Collections.emptyList(), "Returns value stored in widget", "java.net.URL"));
        this.addMethod(Model.method("defaultValue", Collections.singletonList(Model.methodParameter("value", "java.net.URL")), "Sets the default image", "Void"));
        this.addMethod(Model.method("update", Collections.singletonList(Model.methodParameter("value", "java.net.URL")), "Updates image value and refresh widget", "Void"));
    }

    @Override
    protected void addEvents() {
        super.addEvents();
        this.addEvent(Model.method("onChange", Collections.singletonList(Model.methodParameter("listener", "io.intino.alexandria.ui.displays.events.ChangeListener")), "This event is fired when widget value changes", "void").facets(Collections.singletonList("Editable")));
    }
}

