/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.ui.documentation.model;

import io.intino.alexandria.schemas.Method;
import io.intino.alexandria.schemas.Property;
import io.intino.alexandria.schemas.Widget;
import io.intino.alexandria.ui.documentation.Model;
import java.util.Collections;

public abstract class BaseWidget
extends Widget {
    public BaseWidget(String description) {
        this.description(description);
        this.addProperties();
        this.addMethods();
        this.addEvents();
    }

    protected void addProperties() {
        this.add(Model.property("color", Property.Type.Text, "Defines the color for widget", new String[0]));
        this.add(Model.property("format", Property.Type.ReferenceArray, "Add formats to widget. Formats must be declared", new String[0]));
    }

    protected void addMethods() {
        this.addMethod(Model.method("refresh", Collections.emptyList(), "Refresh client side widget", "void"));
    }

    protected void addEvents() {
    }

    protected void add(Property property) {
        this.propertyList().add(property);
    }

    protected void addMethod(Method method) {
        this.methodList().add(method);
    }

    protected void addEvent(Method method) {
        this.eventList().add(method);
    }

    protected String[] multipleArrangements() {
        return new String[]{"Vertical", "Horizontal"};
    }

    protected String[] multipleSpacings() {
        return new String[]{"DP8", "DP16", "DP24", "DP32", "DP40"};
    }
}

