import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTemplateStamp from "alexandria-ui-elements/src/displays/components/TemplateStamp";
import UiBlock from "alexandria-ui-elements/src/displays/components/Block";
import DisplaysWidgetSummaryMold from "ui-elements/gen/displays/templates/WidgetSummaryMold";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import WidgetListMoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import WidgetListMoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class WidgetListMold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new WidgetListMoldNotifier(this);
		this.requester = new WidgetListMoldRequester(this);
	};

	render() {
		const display = !this.state.visible ? {display:'none'} : undefined;
		const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiBlock context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1066198072" format="air" layout="vertical">
					<DisplaysWidgetSummaryMold context={this._context.bind(this)} owner={this._owner.bind(this)} id="a1066198072.a23900885">
					</DisplaysWidgetSummaryMold>
				</UiBlock>
			</div>
		);
	}
}

export default withStyles(styles, { withTheme: true })(withSnackbar(WidgetListMold));
DisplayFactory.register("WidgetListMold", withStyles(styles, { withTheme: true })(withSnackbar(WidgetListMold)));