import React from "react";
import { withStyles } from '@material-ui/core/styles';
import UiTextEditable from "alexandria-ui-elements/src/displays/components/TextEditable";
import UiItem from "alexandria-ui-elements/src/displays/components/Item";
import DynamicTable12MoldNotifier from "alexandria-ui-elements/gen/displays/notifiers/ItemNotifier";
import DynamicTable12MoldRequester from "alexandria-ui-elements/gen/displays/requesters/ItemRequester";
import DisplayFactory from 'alexandria-ui-elements/src/displays/DisplayFactory';
import { withSnackbar } from 'notistack';

const styles = theme => ({});

class DynamicTable12Mold extends UiItem {

	constructor(props) {
		super(props);
		this.notifier = new DynamicTable12MoldNotifier(this);
		this.requester = new DynamicTable12MoldRequester(this);
	};

	render() {
	    const display = !this.state.visible ? {display:'none'} : undefined;
	    const className = "layout vertical center-justified" + (this.hiddenClass() !== "" ? " " + this.hiddenClass() : "");
		return(
			<div style={{width:"100%",height:"100%",...this.props.style,...this.style(),...display}} className={className}>
				<UiTextEditable context={this._context.bind(this)} owner={this._owner.bind(this)} id="a541593632" mode="normal" placeholder="">
				</UiTextEditable>
			</div>
		);
	}


}

export default withStyles(styles, { withTheme: true })(withSnackbar(DynamicTable12Mold));
DisplayFactory.register("DynamicTable12Mold", withStyles(styles, { withTheme: true })(withSnackbar(DynamicTable12Mold)));