import BaseSelectorNotifier from "./BaseSelectorNotifier"

export default class SelectorToggleBoxNotifier extends BaseSelectorNotifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshSelection").toSelf().execute((parameters) => this.element.refreshSelection(parameters.v));
		this.when("refreshDisabledOptions").toSelf().execute((parameters) => this.element.refreshDisabledOptions(parameters.v));
		this.pushLinked = true;
	};
}