import Notifier from "alexandria-ui-elements/src/displays/notifiers/ComponentNotifier";

export default class SearchBoxNotifier extends Notifier {
	constructor(element) {
		super(element);
		this.setup();
	};

	setup() {
		if (this.element == null || this.pushLinked) return;
		super.setup();
		this.when("refreshCount").toSelf().execute((parameters) => this.element.refreshCount(parameters.v));
		this.when("refreshCondition").toSelf().execute((parameters) => this.element.refreshCondition(parameters.v));
		this.pushLinked = true;
	};
}